<?php
namespace Frontend\Common;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;


class Header 
{
   function __construct()
   {
			
   }
	
   function getMenuCmsNav($ULClass='list-unstyled',$IsHomeFirst=false)
   {
	   $NavArray = $this->getPagesNavArray();
		
		
		$NavText = '';
		$NavText .= '<ul class="'.$ULClass.'">';
			
			if($IsHomeFirst==true)
			 $NavText .='<li class="nav-item-cms"><a class="nav-link" href="'.DIR_WS_SITE.'">Home</a></li>';
		 
			foreach($NavArray as $arr){	
				
			  if(count($arr['sub_nav']) >0){
				$NavText .='<li class="nav-item-cms"><a class="nav-link-cms dropdown-btn" href="#">'.$arr['title'].' <i class="fa fa-caret-down"></i></a>
							<div class="dropdown-container">';
							
				foreach($arr['sub_nav'] as $subArr)	
						$NavText .='<a class="dropdown-item" href="'.$subArr['href'].'">'.$subArr['title'].'</a>';
			
				$NavText .='</div>
							</li>';
			  }
			  else{
				$NavText .='<li class="nav-item-cms"><a class="nav-link-cms" href="'.$arr['href'].'">'.$arr['title'].'</a></li>';
			  }
			}
					  
		$NavText .='</ul>';
		
		return $NavText;
	   
   }
   function getMenuTopNav($ULClass='navbar-nav justify-content-center mx-auto fw-semi text-uppercase',$IsHomeFirst=false,$PageNav=true,$PagePrefix=false)
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.menutopnav.txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
			return file_get_contents($filename);
		}	
		
		$NavArray = $this->getMenuTopNavArray();
		if($PageNav==true){
			if($PagePrefix==true)
				$NavArray = $this->getPagesNavArray() + $NavArray;
			else
				$NavArray = $NavArray + $this->getPagesNavArray();
		}
		
		
		$NavText = '';
			
			$HomeNavText = "";;
			if($IsHomeFirst==true)
			 $HomeNavText ='<li class="nav-item dd main-nav custom"><a class="nav-link" href="'.DIR_WS_SITE.'">Home</a></li>';
		 
		$NavText .= '<ul class="'.$ULClass.'">'.$HomeNavText;
		$NavText .= $this->GetNavTextTags("",$NavArray,"list-unstyled","nav-item","nav-link",1);	
		$NavText .='</ul>';
		
		$fp2 = fopen($filename, "w");
		fputs($fp2,$NavText);	
		fclose($fp2);
		return $NavText;
		
   }
   
   function GetNavTextTags($NavText,$NavArray,$ul_class="list-unstyled",$li_class="nav-item",$anc_class="nav-link",$i=1)
   {
	   
		if(count($NavArray) > 0){
			 foreach($NavArray as $arr){
				if($arr['megamenu']=="1"){
					$className ="col-lg-4";
					
					if($arr['megamenucols']=="12")
						$className ="col-lg-1";
					if($arr['megamenucols']=="6")
						$className ="col-lg-2";
					if($arr['megamenucols']=="4")
						$className ="col-lg-3";
						
					$NavText .='<li class="nav-item dropdown has-megamenu"><a class="nav-link dropdown-toggle" id="dropdownMenu_'.$i.'" data-toggle="dropdown" href="#">'.$arr['title'].'</a>
									<div class="dropdown-menu text-capitalize rounded-0 megamenu" role="menu">
										<div class="yamm-content">
											<div class="row g-3 h-100">';
										
					if(count($arr['sub_nav']) >0){
						$ssk=0;
						foreach($arr['sub_nav'] as $subArr){	
							$ssk++;
							$NavText .='<div class="'.$className.' h-100 '.(($arr['megamenucols'] > 0 && $ssk%$arr['megamenucols']==0)?"magamenu-last-cols":"").' magamenu-col-'.$ssk.'">
										<div class="col-megamenu">
										<h6 class="title text-danger fw-semi Bor1"><a href="'.$subArr['href'].'">'.$subArr['title'].'</a></h6>';
							if(count($subArr['sub_nav']) >0){
								 $NavText .='<ul class="list-unstyled">';
								 foreach($subArr['sub_nav'] as $subArr2)
									$NavText .='<li><a role="menuitem" href="'.$subArr2['href'].'">'.$subArr2['title'].'</a></li>';
								 
								 $NavText .='</ul>';
							}			
										
							$NavText .='</div>
										</div>';
						}
					}
					
					$NavText .='			</div>
										</div>
									</div>
								</li>';
				}
				else{	
					 if(count($arr['sub_nav']) >0){
						  if($i <= 500){
							  $i++;
							  $NavText .='<li class="'.$li_class.' sub-nav-'.$i.' dropdown-submenu">
											<a href="#" class="'.$anc_class.' dropdown-toggle" id="dropdownMenu_'.$i.'" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'.$arr['title'].'</a>
											<div class="dropdown-menu" aria-labelledby="dropdownMenu_'.$i.'" role="menu">';
								
									$NavText .='<ul class="'.$ul_class.'">';
									 
														$NavTextInner = "";
														$NavTextInner = $this->GetNavTextTags($NavTextInner,$arr['sub_nav'],$ul_class,$li_class,$anc_class,$i);
												  
										$NavText .=$NavTextInner;
										
									$NavText .='</ul>';
									
									$NavText .='</div></li>';
						  }
					  }
					  else{
						$NavText .='<li class="'.$li_class.'"><a class="'.$anc_class.'" href="'.$arr['href'].'">'.$arr['title'].'</a></li>';  
					  }
				 } 
			 }	
		}
		return $NavText;  
   }
   
	function getMenuTopNavArray()
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.top_nav.txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			
		}
		else
		{
				$ReturnArray = $this->GetCategoryLinkMenu($ReturnArray,'0',true,1);
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				
		}
		
		return $ReturnArray;
   }
   
   function GetCategoryLinkMenu($ReturnArray=array(),$ParentID=0,$Active=true,$i=1)
	{
		$ObjObj = new DataTable(TABLE_CATEGORY);
		$ObjObj2 = new DataTable(TABLE_CATEGORY);
		$ObjObj->where ="ParentID='".$ParentID."' AND TopMenu='1'";
		if($Active==true)
			$ObjObj->where .=" AND Active ='1'";
		
		$Record = $ObjObj->tableSelectAll(array("CategoryID","CategoryName","ParentID","MegaMenu","MegaMenuCols"),"Position ASC");
		if(count($Record) > 0){
			foreach( $Record as $current){
			$current =  (array)$current;
			$ReturnArray[$current['CategoryID']] = array("title"=>MyStripSlashes($current['CategoryName']),
														 "megamenu"=>MyStripSlashes($current['MegaMenu']),
														 "megamenucols"=>MyStripSlashes($current['MegaMenuCols']),
														 "href"=>SKSEOURL('catalog_category','Detail',$current['CategoryID']),	
														 "sub_nav"=>array(),	
														 );
																	 
				if($i <= 500){
					$ReturnArray[$current['CategoryID']]["sub_nav"] = $this->GetCategoryLinkMenu($ReturnArray[$current['CategoryID']]["sub_nav"],$current['CategoryID'],true,$i++);			
				}
			}
		}
		return $ReturnArray;
	}
   
   
   function getPagesNavArray()
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.pages_nav.txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			
		}
		else
		{
				$PageObj = new DataTable(TABLE_CMS_PAGES);
				$PageObj2 = new DataTable(TABLE_CMS_PAGES);
				$PageObj->where ="ParentID='0' and Active ='1'";
				$Record = $PageObj->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
				foreach( $Record as $current)
				{	
					$current =  (array)$current;
					$ReturnArray[$current['PageID']] = array("title"=>MyStripSlashes($current['LinkTitle']),
																  "href"=>SKSEOURL('cms_pages','Detail',$current['PageID']),	
																  "sub_nav"=>array(),	
																 );
																 
					
					
					$PageObj2->where ="ParentID='".(int)$current['PageID']."' and Active ='1'";
					$SubRecord = $PageObj2->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
					if(count($SubRecord) > 0){
						foreach( $SubRecord as $subCurrent){
							$subCurrent =  (array)$subCurrent;
							$ReturnArray[$current['PageID']]['sub_nav'][$subCurrent['PageID']] = array("title"=>MyStripSlashes($subCurrent['LinkTitle']),
																									   "href"=>SKSEOURL('cms_pages','Detail',$subCurrent['PageID']),	
																									   "sub_nav"=>array(),	
																									  );
															 
						}
					}
						
					
				}
				
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				
		}
		
		return $ReturnArray;
   }
   
   function getPagesLeftNav($ParentID=0,$ULClass='list-unstyled components')
   {
		$NavArray = $this->getPagesLeftNavArray($ParentID);
		$NavText = '';
		$NavText .= '<ul class="'.$ULClass.'">';
		
			foreach($NavArray as $lnid=>$arr){	
				
			  if(count($arr['sub_nav']) >0){
				$NavText .='<li class="nav-item">
							<a class="nav-link" href="#LeftPages_'.$lnid.'" data-toggle="collapse" aria-expanded="false" class="dropdown-toggle">'.$arr['title'].' <span class="float-right"><i class="fas fa-angle-down"></i></span></a>
							<ul class="collapse list-unstyled" id="LeftPages_'.$lnid.'">';
							
				foreach($arr['sub_nav'] as $subArr)	
				  $NavText .='<li class="nav-item sub-level-1"><a class="nav-link" href="'.$subArr['href'].'">'.$subArr['title'].'</a></li>';
			
				$NavText .='<li class="nav-item sub-level-1"><a class="nav-link" href="'.$arr['href'].'">View ALL '.$arr['title'].'</a></li>
							</ul>
							</li>';
			  }
			  else{
				$NavText .='<li class="nav-item"><a class="nav-link" href="'.$arr['href'].'">'.$arr['title'].'</a></li>';
			  }
			}
					  
		$NavText .='</ul>';
		
		return $NavText;
		
   }
   
   function getPagesLeftNavArray($ParentID=0)
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.left_pages_nav_".$ParentID.".txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			
		}
		else
		{
				
				$ObjObj2 = new DataTable(TABLE_CMS_PAGES);
				$ObjObj2->where ="PageID='".(int)$ParentID."' and Active ='1'";
				$current = (array)$ObjObj2->tableSelectOne(array("PageID","LinkTitle"),"Position ASC");
				$ReturnArray[$current['PageID']] = array("title"=>MyStripSlashes($current['LinkTitle']),
																  "href"=>SKSEOURL('cms_pages','Detail',$current['PageID']),	
																  "sub_nav"=>array(),	
																 );
																 
				$ObjObj = new DataTable(TABLE_CMS_PAGES);
				$ObjObj->where ="ParentID='".(int)$ParentID."' and Active ='1'";
				$Record = $ObjObj->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
				foreach( $Record as $current)
				{	
					$current =  (array)$current;
					$ReturnArray[$current['PageID']] = array("title"=>MyStripSlashes($current['LinkTitle']),
																  "href"=>SKSEOURL('cms_pages','Detail',$current['PageID']),	
																  "sub_nav"=>array(),	
																 );
																 
					
					$ObjObj2->where ="ParentID='".(int)$current['PageID']."' and Active ='1' ";
					$SubRecord = $ObjObj2->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
					if(count($SubRecord) > 0){
						foreach( $SubRecord as $subCurrent){
							$subCurrent =  (array)$subCurrent;
							$ReturnArray[$current['PageID']]['sub_nav'][$subCurrent['PageID']] = array("title"=>MyStripSlashes($subCurrent['LinkTitle']),
																									   "href"=>SKSEOURL('cms_pages','Detail',$subCurrent['PageID']),	
																									   "sub_nav"=>array(),	
																									  );
															 
						}
					}
					
				}
				
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				
		}
		
		return $ReturnArray;
   }
   
    function getMenuLeftNav()
   {
		$NavArray = $this->getMenuLeftNavArray();
		$NavText = '';
		$NavText .= '<ul class="list-unstyled components">';
		
			foreach($NavArray as $cid=>$arr){	
				
			  if(count($arr['sub_nav']) >0){
				$NavText .='<li class="nav-item">
							<a class="nav-link" href="#LeftCat_'.$cid.'" data-toggle="collapse" aria-expanded="false" class="dropdown-toggle">'.$arr['title'].' <span class="float-right"><i class="fas fa-angle-down"></i></span></a>
							<ul class="collapse list-unstyled" id="LeftCat_'.$cid.'">';
							
				foreach($arr['sub_nav'] as $subArr)	
				  $NavText .='<li class="nav-item sub-level-1"><a class="nav-link" href="'.$subArr['href'].'">'.$subArr['title'].'</a></li>';
			
				$NavText .='<li class="nav-item sub-level-1"><a class="nav-link" href="'.$arr['href'].'">View ALL '.$arr['title'].'</a></li>
							</ul>
							</li>';
			  }
			  else{
				$NavText .='<li class="nav-item"><a class="nav-link" href="'.$arr['href'].'">'.$arr['title'].'</a></li>';
			  }
			}
					  
		$NavText .='</ul>';
		
		return $NavText;
		
   }
   
	function getMenuLeftNavArray()
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.left_nav.txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			
		}
		else
		{
				$ObjObj = new DataTable(TABLE_CATEGORY);
				$ObjObj2 = new DataTable(TABLE_CATEGORY);
				$ObjObj->where ="ParentID='0' and Active ='1'";
				$Record = $ObjObj->tableSelectAll(array("CategoryID","CategoryName"),"Position ASC");
				foreach( $Record as $current)
				{	
					$current =  (array)$current;
					$ReturnArray[$current['CategoryID']] = array("title"=>MyStripSlashes($current['CategoryName']),
																  "href"=>SKSEOURL('catalog_category','Detail',$current['CategoryID']),	
																  "sub_nav"=>array(),	
																 );
																 
					
					$ObjObj2->where ="ParentID='".(int)$current['CategoryID']."' and Active ='1' ";
					$SubRecord = $ObjObj2->tableSelectAll(array("CategoryID","CategoryName"),"Position ASC");
					if(count($SubRecord) > 0){
						foreach( $SubRecord as $subCurrent){
							$subCurrent =  (array)$subCurrent;
							$ReturnArray[$current['CategoryID']]['sub_nav'][$subCurrent['CategoryID']] = array("title"=>MyStripSlashes($subCurrent['CategoryName']),
																									   "href"=>SKSEOURL('catalog_category','Detail',$subCurrent['CategoryID']),	
																									   "sub_nav"=>array(),	
																									  );
															 
						}
					}
					
				}
				
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				
		}
		
		return $ReturnArray;
   }
   
   function getBottomNav()
   {
		$NavArray = $this->getBottomNavArray();
		$NavText = '';
		$NavText .= '<ul class="text-uppercase">';
		
			foreach($NavArray as $arr){	
				
			  if(count($arr['sub_nav']) >0){
				$NavText .='<li class="nav-bottom-item dropdown"><a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'.$arr['title'].'</a>
							<div class="dropdown-menu" aria-labelledby="navbarDropdown">';
							
				foreach($arr['sub_nav'] as $subArr)	
				  $NavText .='<a class="dropdown-item" href="'.$subArr['href'].'">'.$subArr['title'].'</a>';
			
				$NavText .='</div>
							</li>';
			  }
			  else{
				$NavText .='<li class="nav-bottom-item"><a class="nav-bottom-link" href="'.$arr['href'].'">'.$arr['title'].'</a></li>';
			  }
			}
					  
		$NavText .='</ul>';
		
		return $NavText;
		
   }
   
   function getBottomNavArray()
   {
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."cache.bottom_nav.txt";
		$ReturnArray = array();
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$ReturnArray =unserialize(file_get_contents($filename));
			
		}
		else
		{
				$PageObj = new DataTable(TABLE_CMS_PAGES);
				$PageObj2 = new DataTable(TABLE_CMS_PAGES);
				$PageObj->where ="ParentID='0' and Active ='1'";
				$Record = $PageObj->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
				foreach( $Record as $current)
				{	
					$current =  (array)$current;
					$ReturnArray[$current['PageID']] = array("title"=>MyStripSlashes($current['LinkTitle']),
																  "href"=>SKSEOURL('cms_pages','Detail',$current['PageID']),	
																  "sub_nav"=>array(),	
																 );
																 
					
					
					$PageObj2->where ="ParentID='".(int)$current['PageID']."' and Active ='1'";
					$SubRecord = $PageObj2->tableSelectAll(array("PageID","LinkTitle"),"Position ASC");
					if(count($SubRecord) > 0){
						foreach( $SubRecord as $subCurrent){
							$subCurrent =  (array)$subCurrent;
							$ReturnArray[$current['PageID']]['sub_nav'][$subCurrent['PageID']] = array("title"=>MyStripSlashes($subCurrent['LinkTitle']),
																									   "href"=>SKSEOURL('cms_pages','Detail',$subCurrent['PageID']),	
																									   "sub_nav"=>array(),	
																									  );
															 
						}
					}
						
					
				}
				
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($ReturnArray));	
				fclose($fp2);
				
		}
		
		return $ReturnArray;
   }
   
   
   
   
};
